﻿<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Waluty" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
    <HEAD>
        <title>Sprzedaż</title>
        <script runat="server">

            public class ParametryWydrukuDokumentuRR : ContextBase
            {
                public ParametryWydrukuDokumentuRR(Context c) : base(c){       
                    parametry = new ParametryWydrukuDokumentu(c);             
                }
             
  
                ParametryWydrukuDokumentu parametry;
                internal ParametryWydrukuDokumentu Parametry {  get { return parametry; }}

            // tutaj wszystko przelotki z oryginalnych parametrów .

		[Priority(1)]
        public DokumentHandlowy Dokument {
            get {
            return parametry.Dokument;
            }
        }

        [Priority(2)]
		public bool Oryginał {
			get { return parametry.Oryginał; }
			set { 
                parametry.Oryginał = value;
            }
		}


		[Priority(25)]
		[MaxLength(1)]
        [Caption("Ilość kopii")]
		public int IloscKopii
		{
			get
			{
				return parametry.IloscKopii;
			}
			set
			{
				parametry.IloscKopii = value;
			}
		}


		[Priority(50)]
		public bool Duplikat {
			get { return parametry.Duplikat; }
			set { 
                parametry.Duplikat = value; 
            }
		}


            // tu ewentualnie własne property ... 

    }


    ParametryWydrukuDokumentuRR parametryRR;
    [Context]
    public ParametryWydrukuDokumentuRR ParametryRR {
        get { return parametryRR; }
        set { parametryRR = value; }
    }
    


    void OnContextLoad(Object sender, EventArgs args) {
        DataRepeater1.DataSource = (IEnumerable)ParametryRR.Parametry;
        DokumentHandlowy dokument = ParametryRR.Parametry.Dokument;
            
        
                
        //Tylko tyle zostało z kodu liczącego płatności.
        platnik.Visible = dokument.InnyPłatnik;
        
        sww.Visible = dokument.JestSWW;
        RodzajKorektyCol.Visible = dokument.DokumentKorygowany != null;

        //Ukrywamy tabelkę VAT i kolumny VAT dla dokumentów nie VAT
        //Dostosowujemy nazwy kolumn
        string nazwa;
        if (dokument.Definicja.SumyVAT!=SposobLiczeniaSumVAT.NieLiczyć)
            nazwa = "faktury";
        else {
            SectionVAT.Visible = false;
            vat.Visible = false;
            nazwa = "rachunku";
        }

        //Jeżeli dokumenty liczone od brutto, to wymieniamy nagłówki
        if (dokument.OdBrutto)
            wartosc.Caption = "Wartość brutto";
   
        //Formatujemy podpisy
        stPodpis.Caption = "<font size=2>"+dokument.Session.Login.Operator.FullName+"</font><br><br><font size=1>..................................................<br>Podpis nabywcy</font>";
        stOsoba.Caption = "<font size=2>"+dokument.Osoba+"</font><br><br><font size=1>..................................................<br>Podpis sprzedawcy</font>";
    }
    
    void DataRepeater1_BeforeRow(Object sender, EventArgs args) {
        KopiaDokumentu kopia = (KopiaDokumentu)DataRepeater1.CurrentRow;
        DokumentHandlowy dokument = kopia.Dokument;
        if (kopia.Kopia==TypKopiiDokumentu.Duplikat) {
            labelDataDuplikatu.EditValue = Date.Today;
            labelDataDuplikatuText.EditValue = "Data duplikatu: ";
        }
    }
    
    void niezapłacone_BeforeRow(Object sender, RowEventArgs args) {
        WydrukDokumentu.NiezapłaconeInfo p = (WydrukDokumentu.NiezapłaconeInfo)args.Row;
        if (p.Płatność.Podmiot!=p.Płatność.Dokument.Podmiot) {
            platnik.AddLine(p.Płatność.Podmiot.Nazwa);
            platnik.AddLine(p.Płatność.Podmiot.Adres);
        }
    }
        </script>
        <META http-equiv="Content-Type" content="text/html; charset=utf-8">
        <meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
        <meta content="C#" name="CODE_LANGUAGE">
        <meta content="JavaScript" name="vs_defaultClientScript">
        <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
    </HEAD>
<body>
    <form id="Sprzedaż" method="post" runat="server">
        <ea:DataContext ID="dc" runat="server" TypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
            OnContextLoad="OnContextLoad" RightMargin="-1" LeftMargin="-1"></ea:DataContext>
        <ea:DataRepeater ID="DataRepeater1" runat="server" OnBeforeRow="DataRepeater1_BeforeRow"
            RowTypeName="Soneta.Handel.KopiaDokumentu,Soneta.Handel" Width="100%" Height="161px">
            <ea:SectionMarker ID="SectionMarker9" runat="server">
            </ea:SectionMarker>
            <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False">
            </ea:PageBreak>
            <div style="border-top: 1px solid; width: 100%; border-bottom: 1px solid">
                <table id="Table4" style="font-size: 10px; font-family: Tahoma" width="100%">
                    <tr>
                        <td style="font-weight: bold; font-size: medium;" valign="top" align="left">
                            <ea:DataLabel ID="DataLabel19" runat="server" DataMember="Dokument.Definicja.TytulWydruku">
                            </ea:DataLabel>
                            <ea:DataLabel ID="DataLabel20" runat="server" DataMember="Dokument.Session.Handel.Config.Ogólne.MałyPodatnik">
                                <ValuesMap>
                                    <ea:ValuesPair Key="False" Value=""></ea:ValuesPair>
                                    <ea:ValuesPair Key="True" Value=" MP"></ea:ValuesPair>
                                </ValuesMap>
                            </ea:DataLabel>
                            &nbsp;nr
                            <ea:DataLabel ID="DataLabel15" runat="server" DataMember="Dokument.Numer">
                            </ea:DataLabel>
                            <ea:DataLabel ID="DataLabel4" runat="server" DataMember="Dokument.Stan">
                                <ValuesMap>
                                    <ea:ValuesPair Key="Anulowany" Value="&lt;br&gt;Dokument został anulowany"></ea:ValuesPair>
                                    <ea:ValuesPair Key="Bufor" Value="&lt;br&gt;Dokument nie został zatwierdzony"></ea:ValuesPair>
                                    <ea:ValuesPair Key="Zablokowany" Value=""></ea:ValuesPair>
                                    <ea:ValuesPair Key="Zatwierdzony" Value=""></ea:ValuesPair>
                                </ValuesMap>
                            </ea:DataLabel>
                            <br>
                            <span style="font-weight: normal; font-size: 13px;">
                                <ea:DataLabel ID="DataLabel18" runat="server" DataMember="Kopia" Bold="False">
                                </ea:DataLabel>
                            </span>
                        </td>
                        <td valign="top" align="right">
                            <ea:DataLabel ID="DataLabel36" runat="server" DataMember="Dokument.Definicja.NazwaDatyEtykieta"
                                Bold="False">
                            </ea:DataLabel>
                            <br>
                            <ea:DataLabel ID="DataLabel35" runat="server" DataMember="Dokument.Definicja.NazwaDatyOperacjiEtykieta"
                                Bold="False">
                            </ea:DataLabel>
                            <br>
                            <ea:DataLabel ID="labelDataDuplikatuText" runat="server" Bold="False">
                            </ea:DataLabel>
                        </td>
                        <td width="10">
                        </td>
                        <td valign="top" align="right">
                            <ea:DataLabel ID="DataLabel21" runat="server" DataMember="Dokument.Data">
                            </ea:DataLabel>
                            <br>
                            <ea:DataLabel ID="DataLabel22" runat="server" DataMember="Dokument.DataOperacji">
                            </ea:DataLabel>
                            <br>
                            <ea:DataLabel ID="labelDataDuplikatu" runat="server">
                            </ea:DataLabel>
                            <br>
                        </td>
                    </tr>
                </table>
            </div>
            <table id="Table1" width="100%">
                <tr>
                    <td valign="top" colspan="2">
                        <ea:Section ID="Section4" runat="server" Width="100%" DataMember="Dokument.DokumentKorygowany"
                            ConditionValue="IS NOT NULL">
                            <em><u>Dokument korygowany:</u></em>
                            <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
                                <ea:DataLabel ID="DataLabel23" runat="server" DataMember="Dokument.DokumentKorygowanyPierwszy.Numer">
                                </ea:DataLabel>
                                <br>
                                <ea:DataLabel ID="DataLabel37" runat="server" DataMember="Dokument.DokumentKorygowanyPierwszy.Definicja.NazwaDatyEtykieta"
                                    Bold="False">
                                </ea:DataLabel>
                                <ea:DataLabel ID="DataLabel38" runat="server" DataMember="Dokument.DokumentKorygowanyPierwszy.Data">
                                </ea:DataLabel>
                                <br>
                                <ea:DataLabel ID="DataLabel39" runat="server" DataMember="Dokument.DokumentKorygowanyPierwszy.Definicja.NazwaDatyOperacjiEtykieta"
                                    Bold="False">
                                </ea:DataLabel>
                                <ea:DataLabel ID="DataLabel40" runat="server" DataMember="Dokument.DokumentKorygowanyPierwszy.DataOperacji">
                                </ea:DataLabel>
                            </div>
                        </ea:Section>
                    </td>
                </tr>
                <tr>
                    <td valign="top" width="50%">
                        <em><u>Sprzedawca:</u></em>
                        <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
                            <ea:DataLabel ID="DataLabel13" runat="server" DataMember="Dokument.DaneKontrahenta.NazwaFormatowana">
                            </ea:DataLabel>
                            <br>
                            <ea:DataLabel ID="Datalabel16" runat="server" DataMember="Dokument.DaneKontrahenta.Adres.Linia1"
                                Bold="False">
                            </ea:DataLabel>
                            <br>
                            <ea:DataLabel ID="Datalabel17" runat="server" DataMember="Dokument.DaneKontrahenta.Adres.Linia2"
                                Bold="False">
                            </ea:DataLabel>
                            <br>
                            NIP:
                            <ea:DataLabel ID="DataLabel14" runat="server" DataMember="Dokument.DaneKontrahenta.NIP" Bold="False">
                            </ea:DataLabel>
                            <br />
                            <em><span style="text-decoration: underline">Konto bankowe:</span></em>
                            <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
                                <ea:DataLabel ID="labelBank" runat="server" Bold="False" DataMember="Dokument.Kontrahent.DomyslnyRachunek.Rachunek.Bank.Nazwa"
                                    Format="{0}<br>">
                                </ea:DataLabel>
                                <ea:DataLabel ID="labelSwift" runat="server" Bold="False" DataMember="Dokument.Kontrahent.DomyslnyRachunek.Rachunek.SWIFT"
                                    Format="SWIFT: {0}<br>">
                                </ea:DataLabel>
                                <ea:DataLabel ID="DataLabel8" runat="server" Bold="False" DataMember="Dokument.Kontrahent.DomyslnyRachunek.Rachunek.Numer">
                                </ea:DataLabel>
                            </div>
                        </div>
                        <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
                            &nbsp;&nbsp;
                        </div>
                    </td>
                    <td valign="top">
                        <em><u>Nabywca:</u></em>
                        <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
                            <ea:DataLabel ID="DataLabel1" runat="server" DataMember="Dokument.Session.Core.Config.Firma.Pieczątka.NazwaFormatowana">
                            </ea:DataLabel>
                            <br>
                            <ea:DataLabel ID="DataLabel2" runat="server" DataMember="Dokument.Session.Core.Config.Firma.AdresSiedziby.Linia1"
                                Bold="False">
                            </ea:DataLabel>
                            <br>
                            <ea:DataLabel ID="DataLabel3" runat="server" DataMember="Dokument.Session.Core.Config.Firma.AdresSiedziby.Linia2"
                                Bold="False">
                            </ea:DataLabel>
                            <br>
                            NIP:
                            <ea:DataLabel ID="DataLabel11" runat="server" DataMember="Dokument.Wydruk.NIP"
                                Bold="False">
                            </ea:DataLabel>
                        </div>
                    </td>
                </tr>
            </table>
            <ea:Section ID="KursSection" runat="server" Width="100%" DataMember="Dokument.Wydruk.JestWaluta">
                <font size="2">Kurs <strong>1 </strong>
                    <ea:DataLabel ID="DataLabel31" runat="server" DataMember="Dokument.BruttoCy.Symbol">
                    </ea:DataLabel>
                    &nbsp;=
                    <ea:DataLabel ID="KursWaluty" runat="server" DataMember="Dokument.KursWaluty">
                    </ea:DataLabel>
                    <strong>&nbsp;PLN</strong> z dnia
                    <ea:DataLabel ID="DataLabel32" runat="server" DataMember="Dokument.DataOgłoszeniaKursu">
                    </ea:DataLabel>
                    &nbsp;(<ea:DataLabel ID="DataLabel33" runat="server" DataMember="Dokument.TabelaKursowa">
                    </ea:DataLabel>
                    )</font></ea:Section>
            <ea:Grid ID="Grid1" runat="server" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel"
                DataMember="Dokument.Wydruk.PozycjeRazem" RowsInRow="2" GroupData0="Workers.WydrukPozycji.SekcjaDokumentu"
                GroupLine="{0}">
                <Columns>
                    <ea:GridColumn Width="4" Align="Right" DataMember="Lp" Caption="Lp." RowSpan="2"
                        runat="server">
                    </ea:GridColumn>
                    <ea:GridColumn DataMember="NazwaPierwszaLinia" Caption="Nazwa towaru/usługi" runat="server">
                    </ea:GridColumn>
                    <ea:GridColumn DataMember="NazwaResztaLinii" Caption=" " runat="server">
                    </ea:GridColumn>
                    <ea:GridColumn Width="10" RightBorder="None" Align="Right" DataMember="Ilosc.Value"
                        Caption="Ilość" RowSpan="2" runat="server">
                    </ea:GridColumn>
                    <ea:GridColumn Width="5" DataMember="Ilosc.Symbol" Caption="jm." RowSpan="2" runat="server">
                    </ea:GridColumn>
                    <ea:GridColumn Width="15" Align="Right" DataMember="CenaNettoPoRabacie" Caption="Cena netto"
                        RowSpan="2" runat="server">
                    </ea:GridColumn>
                    <ea:GridColumn Width="15" Align="Right" DataMember="CenaBruttoPoRabacie" Caption="Cena brutto"
                        RowSpan="2" runat="server">
                    </ea:GridColumn>
                    <ea:GridColumn Width="16" Align="Right" DataMember="WartoscCy" Caption="Wartość netto"
                        Format="&lt;b&gt;{0}&lt;/b&gt;" ID="wartosc" RowSpan="2" runat="server">
                    </ea:GridColumn>
                    <ea:GridColumn Width="10" Align="Right" DataMember="DefinicjaStawki" Caption="Stawka VAT"
                        ID="vat" RowSpan="2" runat="server">
                    </ea:GridColumn>
                    <ea:GridColumn Width="15" DataMember="SWW" Caption="SWW/PKWiU" ID="sww" RowSpan="2"
                        runat="server">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" ID="RodzajKorektyCol" DataMember="RodzajKorektyOpis" Width="16"
                        Caption="Zmiana" RowSpan="2" Align="Center">
                    </ea:GridColumn>
                </Columns>
            </ea:Grid>
            <ea:Section ID="SectionVAT" runat="server" Width="100%">
                <table cellpadding="0" cellspacing="0" border="0">
                    <tr>
                        <td width="100%" style="font-size: 10px;">
                            <ea:DataLabel ID="DataLabel24" runat="server" DataMember="Dokument.Wydruk.InfoKorekty1"
                                Bold="False">
                            </ea:DataLabel>
                            <br />
                            <ea:DataLabel ID="DataLabel41" runat="server" DataMember="Dokument.Wydruk.InfoKorekty2"
                                Bold="False">
                            </ea:DataLabel>
                        </td>
                        <td align="right">
                            <ea:Grid ID="Grid5" runat="server" RowTypeName="Soneta.Handel.SumaVAT,Soneta.Handel"
                                DataMember="Dokument.SumyVAT" WithSections="False">
                                <Columns>
                                    <ea:GridColumn Width="15" Align="Right" DataMember="DefinicjaStawki" Total="Info"
                                        Caption="Stawka VAT" runat="server">
                                    </ea:GridColumn>
                                    <ea:GridColumn Width="17" Align="Right" DataMember="Suma.NettoCy" Total="Sum" Caption="Netto"
                                        runat="server">
                                    </ea:GridColumn>
                                    <ea:GridColumn Width="17" Align="Right" DataMember="Suma.VATCy" Total="Sum" Caption="Kwota VAT"
                                        Format="{0:n}" runat="server">
                                    </ea:GridColumn>
                                    <ea:GridColumn Width="17" Align="Right" DataMember="Suma.BruttoCy" Total="Sum" Caption="Brutto"
                                        runat="server">
                                    </ea:GridColumn>
                                </Columns>
                            </ea:Grid>
                        </td>
                    </tr>
                </table>
            </ea:Section>
            <ea:Section ID="Section3" runat="server" DataMember="Dokument.Wydruk.JestSumaPozycji"
                Width="100%">
                <em>Suma&nbsp;brutto dokumentu:</em>
                <ea:DataLabel ID="DataLabel34" runat="server" DataMember="Dokument.SumaPozycji.Brutto">
                </ea:DataLabel>
                &nbsp;PLN<br>
            </ea:Section>
            <ea:Section ID="sectionZaliczki" runat="server" DataMember="Dokument.DokumentyZaliczkowe">
                <em>Faktury zaliczkowe:<br>
                </em>
                <ea:Grid ID="gridZaliczki" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
                    DataMember="Dokument.DokumentyZaliczkowe" WithSections="False">
                    <Columns>
                        <ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp.">
                        </ea:GridColumn>
                        <ea:GridColumn runat="server" Width="30" DataMember="Numer">
                        </ea:GridColumn>
                        <ea:GridColumn runat="server" Width="15" Align="Center" DataMember="Data" Total="Info">
                        </ea:GridColumn>
                        <ea:GridColumn runat="server" Width="18" Align="Right" DataMember="BruttoCy" Total="Sum"
                            Caption="Wartość">
                        </ea:GridColumn>
                    </Columns>
                </ea:Grid>
                <br>
            </ea:Section>
            <table id="Table3" cellspacing="0" cellpadding="0" width="90%">
                <tr>
                    <td style="width: 151px; height: 22px;" align="right" width="151">
                    </td>
                    <td style="width: 145px; border-bottom: black 1px solid; height: 22px;" valign="bottom" align="left"
                        width="145" colspan="1" rowspan="1">
                        <ea:DataLabel ID="doZaplaty" runat="server" DataMember="Dokument.Wydruk.KierunekZapłaty"
                            Bold="False" Format="{0}:">
                        </ea:DataLabel>
                    </td>
                    <td style="font-weight: bold; font-size: 18px; border-bottom: black 1px solid;
                        height: 22px" valign="bottom" align="right">
                        <ea:DataLabel ID="DataLabel5" runat="server" DataMember="Dokument.BruttoCy" Bold="False">
                        </ea:DataLabel>
                    </td>
                </tr>
                <tr>
                    <td style="width: 151px" align="right">
                    </td>
                    <td style="width: 145px" align="left">
                        <font size="2"><em>Słownie:</em></font></td>
                    <td align="right">
                        <font size="2"><em>
                            <ea:DataLabel ID="DataLabel6" runat="server" DataMember="Dokument.BruttoCy" Bold="False"
                                Format="{0:+t}">
                            </ea:DataLabel>
                        </em></font>
                    </td>
                </tr>
            </table>
            <ea:Section ID="sectionWplaty" runat="server" DataMember="Dokument.Zaliczki">
                <em>Rozliczone zaliczki:<br>
                </em>
                <ea:Grid ID="Grid2" runat="server" RowTypeName="Soneta.Handel.RelacjaZaliczki,Soneta.Handel"
                    DataMember="Dokument.Zaliczki" WithSections="False">
                    <Columns>
                        <ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp.">
                        </ea:GridColumn>
                        <ea:GridColumn runat="server" Width="20" DataMember="Zaplata.SposobZaplaty" Caption="Spos&#243;b zapłaty">
                        </ea:GridColumn>
                        <ea:GridColumn runat="server" Width="15" Align="Center" DataMember="Zaplata.DataDokumentu"
                            Caption="Data">
                        </ea:GridColumn>
                        <ea:GridColumn runat="server" Width="20" Align="Right" DataMember="Kwota">
                        </ea:GridColumn>
                        <ea:GridColumn runat="server" Width="25" DataMember="Zaplata.NumerDokumentu" Caption="Numer">
                        </ea:GridColumn>
                    </Columns>
                </ea:Grid>
            </ea:Section>
            <br />
            <ea:Section ID="Section1" runat="server">
                <em>                
                    <ea:DataLabel ID="DataLabel9" runat="server" DataMember="Dokument.Wydruk.ZaplaconoInfo"
                        Bold="False">
                    </ea:DataLabel>                    
                    </em>
            </ea:Section>
            <br />
            Kwota zryczałtowanego zwrotu podatku:
            <ea:DataLabel ID="DataLabel7" runat="server" DataMember="Dokument.Suma.VAT">
            </ea:DataLabel>
            <br />
            <br />
            <ea:Section ID="sectionNiezaplacone" runat="server" DataMember="Dokument.Wydruk.SąNiezapłacone">
                <div>
                    <em>Pozostało do zapłaty:</em>
                    <ea:Grid ID="niezapłacone" runat="server" OnBeforeRow="niezapłacone_BeforeRow" RowTypeName="Soneta.Kasa.Platnosc,Soneta.Kasa"
                        DataMember="Dokument.Wydruk.Niezapłacone" WithSections="False">
                        <Columns>
                            <ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp.">
                            </ea:GridColumn>
                            <ea:GridColumn runat="server" Width="20" DataMember="Płatność.SposobZaplaty" Caption="Spos&#243;b zapłaty">
                            </ea:GridColumn>
                            <ea:GridColumn runat="server" Width="15" Align="Center" DataMember="Płatność.Termin"
                                Caption="Termin">
                            </ea:GridColumn>
                            <ea:GridColumn runat="server" Width="20" Align="Right" DataMember="Kwota">
                            </ea:GridColumn>
                            <ea:GridColumn runat="server" Caption="Płatnik" Format="{0:H}" ID="platnik">
                            </ea:GridColumn>
                        </Columns>
                    </ea:Grid>
                </div>
            </ea:Section>

            <p style="font-family: Tahoma, Arial; font-size: 13px;">
                <ea:DataLabel ID="OpisDok" runat="server" DataMember="Dokument.Opis" Bold="False"> </ea:DataLabel>
            </p>
            <p style="font-family: Tahoma, Arial; font-size: 13px;">
                <ea:DataLabel ID="OpisWydruku" runat="server" DataMember="Dokument.Wydruk.OpisWydruku" Bold="False"> </ea:DataLabel>
            </p>

            <p>
                <table style="width: 100%">
                    <tr>
                        <td style="text-justify: inter-word; font-size: 8pt; width: 50%; font-family: Tahoma;
                            text-align: justify">
                    Oświadczam, że jestem rolnikiem ryczałtowym zwolnionym od podatku od towarów i usług
                    na podstawie art. 43 ust. 1 pkt 3 ustawy o podatku od towarów i usług</td>
                        <td style="width: 100px">
                        </td>
                    </tr>
                </table>
            </p>
            <cc1:ReportFooter ID="ReportFooter1" runat="server" Height="105px" TheEnd="False">
                <Subtitles>
                    <cc1:FooterSubtitle runat="server" Caption="Operator" ID="stOsoba" SubtitleType="CenterText"
                        Width="50">
                    </cc1:FooterSubtitle>
                    <cc1:FooterSubtitle runat="server" Caption="Osoba" ID="stPodpis" SubtitleType="CenterText"
                        Width="50">
                    </cc1:FooterSubtitle>
                </Subtitles>
            </cc1:ReportFooter>
            <ea:SectionMarker ID="SectionMarker8" runat="server" SectionType="Footer">
            </ea:SectionMarker>
        </ea:DataRepeater>
    </form>
</body>
</html>
